	function PLOT_ATT_S_Z(Att, S, wT, axis_Amax, axis_S_max)
	
	%	Plots the attenuation and noise spectrum for a digital filter in a single plot
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2010-05-22
	% 	Modified by: 	LW 2010-11-16
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		Zoom on does not work properly
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% PowerPoint settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	%========================================================	
	subplot('position', [0.1 0.4 0.80 0.5]);
	[AX, H1, H2] = plotyy(wT, Att, wT, S);	
	
	axes(AX(1))
	axis([0 pi 0 axis_Amax]);
	set(AX(1),'XTick', []);
	set(AX(2),'XTick', []);
	set(H1, 'linewidth', lw);
	set(H2, 'linewidth', lw);
	set(AX(1), 'ylim', [0 axis_Amax]);
	set(AX(1), 'ytick', [0:10:axis_Amax]);
	set(AX(2), 'ylim', [0 axis_S_max]);
	set(AX(2), 'ytick', [0:axis_S_max*10/axis_Amax:axis_S_max]);
	
	% ===========================================================
	% Need to be adapted
	%	text(22, 40,'Group Delay','FontName',fn,'FontSize',fs);
	%	text(42, 20,'Attenuation','FontName',fn,'FontSize',fs);
	% ===========================================================
	
	set(gca,'FontName', fn,'FontSize', fs);	
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName',fn,'FontSize',fs);
	axes(AX(2))
	set(gca,'FontName', fn,'FontSize', fs);	
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize',fs);	
	
	ylabel('{\itS}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	axis_S_min = 0;
	axis([0 pi axis_S_min axis_S_max]);	
	grid on;
	hold on
	AX = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(AX, lab);
	box on;		
